/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Fop;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;

public class FopErrorListener
implements ErrorListener,
MessageSource {
    private Target baseClass = null;
    private String filename = null;
    private ShapeChangeResult result = null;

    public FopErrorListener(String name, ShapeChangeResult res, Target bc) {
        this.filename = name;
        this.result = res;
        this.baseClass = bc;
    }

    @Override
    public void warning(TransformerException arg0) throws TransformerException {
        String warn = arg0.getMessage();
        this.result.addWarning(this, 303, this.filename, warn);
    }

    @Override
    public void error(TransformerException arg0) throws TransformerException {
        String err = arg0.getMessage();
        this.result.addError(null, 304, this.filename, err);
    }

    @Override
    public void fatalError(TransformerException arg0) throws TransformerException {
        String fatal = arg0.getMessage();
        this.result.addError(this, 305, this.filename, fatal);
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 303: {
                return "Warning while transforming '$1$'. Message: $2$";
            }
            case 305: {
                return "Fatal error while transforming '$1$'. Message: $2$";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

