/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.FOL;

import de.interactive_instruments.ShapeChange.FOL.Expression;
import de.interactive_instruments.ShapeChange.FOL.PropertyCall;
import de.interactive_instruments.ShapeChange.FOL.SchemaCall;
import de.interactive_instruments.ShapeChange.SBVR.SbvrUtil;

public class Variable
extends Expression {
    public static int index = 1;
    public static final String NAME_PREFIX = "x";
    public static final String SELF_VARIABLE_NAME = "self";
    private String name;
    private Variable nextOuterScope;
    private SchemaCall value;

    public Variable() {
        this.name = NAME_PREFIX + index;
        ++index;
    }

    public Variable(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Variable getNextOuterScope() {
        return this.nextOuterScope;
    }

    public void setNextOuterScope(Variable nextOuterScope) {
        this.nextOuterScope = nextOuterScope;
    }

    public SchemaCall getValue() {
        return this.value;
    }

    public void setValue(SchemaCall value) {
        this.value = value;
    }

    public SchemaCall getLastSegmentInValue() {
        if (this.value == null) {
            return null;
        }
        SchemaCall current = this.value;
        while (current.getNextElement() != null) {
            current = current.getNextElement();
        }
        return current;
    }

    public PropertyCall lastPropertyCallInEffectiveValue() {
        if (this.value != null) {
            PropertyCall lastPC;
            SchemaCall current = this.value;
            PropertyCall propertyCall = lastPC = current instanceof PropertyCall ? (PropertyCall)current : null;
            while (current.getNextElement() != null) {
                if (!((current = current.getNextElement()) instanceof PropertyCall)) continue;
                lastPC = (PropertyCall)current;
            }
            if (lastPC != null) {
                return lastPC;
            }
        }
        if (this.nextOuterScope != null) {
            return this.nextOuterScope.lastPropertyCallInEffectiveValue();
        }
        return null;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String toStringWithValue() {
        return this.name + ":" + (this.value == null ? "<null>" : this.value.toString());
    }

    public boolean isSelf() {
        return this.name.equals(SELF_VARIABLE_NAME);
    }

    public static void reset() {
        index = 1;
    }

    public void prependSchemaCallToValue(SchemaCall sc) {
        if (sc == null) {
            return;
        }
        SchemaCall scCopy = SbvrUtil.copy(sc);
        scCopy.setVariableContext(this);
        this.value.setVariableContext(null);
        scCopy.getLastElement().setNextElement(this.value);
        this.value = scCopy;
    }
}

