/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.ModelProvider;
import de.interactive_instruments.ShapeChange.Model.Transformer;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;

public class DefaultModelProvider
implements ModelProvider,
MessageSource {
    private ShapeChangeResult result;
    private Options options;

    public DefaultModelProvider(ShapeChangeResult result, Options options) {
        this.result = result;
        this.options = options;
    }

    @Override
    public Model getModel(String modelType, String repoFileNameOrConnectionString, String username, String password, boolean isLoadingInputModel, String inputModelTransformer) throws ShapeChangeAbortException {
        String pwd;
        if (StringUtils.isBlank((CharSequence)repoFileNameOrConnectionString)) {
            this.result.addFatalError(this, 24);
            throw new ShapeChangeAbortException();
        }
        String user = username == null ? "" : username;
        String string = pwd = password == null ? "" : password;
        if (modelType == null) {
            this.result.addFatalError(this, 26);
            throw new ShapeChangeAbortException();
        }
        if (modelType.equalsIgnoreCase("ea7")) {
            modelType = "de.interactive_instruments.ShapeChange.Model.EA.EADocument";
        } else if (modelType.equalsIgnoreCase("xmi10")) {
            modelType = "de.interactive_instruments.ShapeChange.Model.Xmi10.Xmi10Document";
        } else if (modelType.equalsIgnoreCase("gcsr")) {
            modelType = "gov.nga.ShapeChange.Model.GCSR.GCSRModel";
        } else if (modelType.equalsIgnoreCase("scxml")) {
            modelType = "de.interactive_instruments.ShapeChange.Model.Generic.GenericModel";
        } else {
            this.result.addInfo(this, 27, modelType);
        }
        if (isLoadingInputModel && StringUtils.isNotBlank((CharSequence)inputModelTransformer)) {
            try {
                Class<?> theClass = Class.forName(inputModelTransformer);
                Transformer t = (Transformer)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                t.initialise(this.options, this.result, repoFileNameOrConnectionString);
                t.transform();
                t.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ShapeChangeAbortException();
            }
        }
        Model m = null;
        try {
            Class<?> theClass = Class.forName(modelType);
            if (theClass == null) {
                this.result.addFatalError(this, 17, modelType);
                throw new ShapeChangeAbortException();
            }
            m = (Model)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (m != null) {
                if (user.length() == 0) {
                    m.initialise(this.result, this.options, repoFileNameOrConnectionString);
                } else {
                    m.initialise(this.result, this.options, repoFileNameOrConnectionString, user, pwd);
                }
            } else {
                this.result.addFatalError(this, 17, modelType);
                throw new ShapeChangeAbortException();
            }
            m.loadInformationFromExternalSources(isLoadingInputModel);
            m.postprocessAfterLoadingAndValidate();
        }
        catch (ClassNotFoundException e) {
            this.result.addFatalError(this, 17, modelType);
            throw new ShapeChangeAbortException();
        }
        catch (IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.result.addFatalError(this, 19, modelType);
            throw new ShapeChangeAbortException();
        }
        catch (IllegalAccessException e) {
            this.result.addFatalError(this, 20, modelType);
            throw new ShapeChangeAbortException();
        }
        return m;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 17: {
                return "Unknown model type: '$1$'.";
            }
            case 19: {
                return "Model object could not be instantiated: '$1$'.";
            }
            case 20: {
                return "Model object could not be accessed: '$1$'.";
            }
            case 24: {
                return "Repository filename or connection string was not provided. Cannot connect to a repository.";
            }
            case 26: {
                return "Model type not provided.";
            }
            case 27: {
                return "Using custom model implementation: '$1$'.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

