/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.BasicConfigurationValidator;
import de.interactive_instruments.ShapeChange.ConfigurationValidator;
import de.interactive_instruments.ShapeChange.DefaultModelProvider;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.OutputFileAlterationListener;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessMode;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.DeferrableOutputWriter;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.Target.TargetOutputProcessor;
import de.interactive_instruments.ShapeChange.Target.TargetUtil;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import de.interactive_instruments.ShapeChange.Transformation.TransformationManager;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.UI.StatusBoard;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class Converter
implements MessageSource {
    public static final int STATUS_TARGET_INITSTART = 201;
    public static final int STATUS_TARGET_PROCESS = 202;
    public static final int STATUS_TARGET_WRITE = 203;
    public static final int STATUS_TARGET_WRITEALL = 204;
    public static final int STATUS_TARGET_DEFERRED_WRITE = 205;
    public static final int STATUS_TRANSFORMER_PROCESS = 206;
    protected ShapeChangeResult result = null;
    protected Options options = null;
    protected Target target = null;
    protected Set<String> processIdsToIgnore = new HashSet<String>();
    protected TargetOutputProcessor outputProcessor = null;
    private PackageInfo mainSchemaForSingleTargets;

    public Converter(Options o, ShapeChangeResult r) {
        this.options = o;
        this.result = r;
        this.target = null;
        this.outputProcessor = new TargetOutputProcessor(r);
    }

    public void convert() throws ShapeChangeAbortException {
        boolean skipSemanticValidation = false;
        if (this.options.parameter("skipSemanticValidationOfShapeChangeConfiguration") != null && this.options.parameter("skipSemanticValidationOfShapeChangeConfiguration").trim().equalsIgnoreCase("true")) {
            skipSemanticValidation = true;
        }
        if (skipSemanticValidation) {
            this.result.addProcessFlowInfo(this, 512);
        } else {
            this.result.addProcessFlowInfo(this, 510);
            boolean isValidConfig = this.validateConfiguration();
            this.result.addProcessFlowInfo(this, 511);
            if (!isValidConfig) {
                ShapeChangeResult.MessageContext mc = this.result.addProcessFlowError(this, 509);
                if (mc != null) {
                    mc.addDetail(this, 513);
                }
                return;
            }
        }
        if (this.options.isOnlyDeferrableOutputWrite()) {
            this.executeDeferrableOutputWriters();
        } else {
            String imt = this.options.parameter("inputModelType");
            String mdl = this.options.parameter("inputFile");
            String repoFileNameOrConnectionString = this.options.parameter("repositoryFileNameOrConnectionString");
            String connection = StringUtils.isNotBlank((CharSequence)repoFileNameOrConnectionString) ? repoFileNameOrConnectionString : mdl;
            String username = this.options.parameter("username");
            String password = this.options.parameter("password");
            String transformer = this.options.parameter("transformer");
            DefaultModelProvider mp = new DefaultModelProvider(this.result, this.options);
            Model m = mp.getModel(imt, connection, username, password, true, transformer);
            this.convert(m);
        }
    }

    private boolean validateConfiguration() throws ShapeChangeAbortException {
        BasicConfigurationValidator bcv = new BasicConfigurationValidator();
        boolean isValid = bcv.isValid(null, this.options, this.result);
        ArrayList<ProcessConfiguration> processConfigs = new ArrayList<ProcessConfiguration>();
        processConfigs.addAll(this.options.getTransformerConfigs().values());
        processConfigs.addAll(this.options.getTargetConfigurations());
        for (ProcessConfiguration pConfig : processConfigs) {
            if (pConfig.getProcessMode() == ProcessMode.disabled) continue;
            try {
                ProcessConfiguration tconfig;
                Class<?> theClass = Class.forName(pConfig.getClassName() + "ConfigurationValidator");
                ConfigurationValidator validator = (ConfigurationValidator)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (pConfig instanceof TransformerConfiguration) {
                    tconfig = (TransformerConfiguration)pConfig;
                    this.result.addProcessFlowInfo(this, 514, ((TransformerConfiguration)tconfig).getId());
                } else {
                    tconfig = (TargetConfiguration)pConfig;
                    this.result.addProcessFlowInfo(this, 515, tconfig.getClassName(), StringUtils.join(((TargetConfiguration)tconfig).getInputIds(), (String)" "));
                }
                isValid &= validator.isValid(pConfig, this.options, this.result);
            }
            catch (ClassNotFoundException theClass) {
            }
            catch (Exception e) {
                this.result.addProcessFlowWarning(this, 508, pConfig.getClassName(), e.getMessage());
            }
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDeferrableOutputWriters() {
        try {
            this.executeDeferrableOutputWriters(this.options.getTargetConfigurations());
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addProcessFlowError(m);
            }
            Exception se = e;
            if (e instanceof SAXException) {
                se = ((SAXException)e).getException();
            }
            if (se != null) {
                se.printStackTrace(System.err);
            } else {
                e.printStackTrace(System.err);
            }
        }
        finally {
            this.result.toFile(this.options.parameter("logFile"));
            this.target = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(Model model) {
        try {
            if (model == null) {
                this.result.addProcessFlowFatalError(this, 14);
                throw new ShapeChangeAbortException();
            }
            SortedSet<? extends PackageInfo> selectedSchema = model.selectedSchemas();
            if (selectedSchema == null || selectedSchema.isEmpty()) {
                this.result.addProcessFlowWarning(this, 507);
                this.release(model);
            } else {
                this.executeTargets(model, this.options.getInputId(), this.options.getInputTargetConfigs());
                this.executeTransformations(model, this.options.getInputTransformerConfigs());
                this.release(model);
                this.executeDeferrableOutputWriters(this.options.getTargetConfigurations());
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addProcessFlowError(m);
            }
            Exception se = e;
            if (e instanceof SAXException) {
                se = ((SAXException)e).getException();
            }
            if (se != null) {
                se.printStackTrace(System.err);
            } else {
                e.printStackTrace(System.err);
            }
        }
        finally {
            this.result.toFile(this.options.parameter("logFile"));
            this.target = null;
        }
    }

    private void release(Model model) {
        if (model != null) {
            model.shutdown();
        }
        model = null;
    }

    private void executeDeferrableOutputWriters(List<TargetConfiguration> targetConfigs) throws Exception {
        for (TargetConfiguration tgt : targetConfigs) {
            String classname;
            Class<?> theClass;
            if (tgt.getProcessMode().equals((Object)ProcessMode.disabled) || !this.isDeferrableOutputWriter(theClass = Class.forName(classname = tgt.getClassName()))) continue;
            this.options.setCurrentProcessConfig(tgt);
            this.options.resetFields();
            String outputDirectoryForTarget = this.options.parameter(tgt.getClassName(), "outputDirectory");
            for (String modelProviderId : tgt.getInputIds()) {
                if (this.processIdsToIgnore.contains(modelProviderId)) continue;
                Object outputDirectory = outputDirectoryForTarget;
                if (StringUtils.isNotBlank((CharSequence)outputDirectoryForTarget)) {
                    outputDirectory = outputDirectoryForTarget.trim() + File.separator + modelProviderId;
                    this.options.setParameter(tgt.getClassName(), "outputDirectory", (String)outputDirectory);
                }
                OutputFileAlterationListener faListener = new OutputFileAlterationListener();
                FileAlterationObserver outputObserver = this.setupOutputFileAlterationObserver((String)outputDirectory, faListener, tgt);
                DeferrableOutputWriter dowTarget = (DeferrableOutputWriter)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                dowTarget.initialise(this.options, this.result);
                StatusBoard.getStatusBoard().statusChanged(205);
                dowTarget.writeOutput();
                dowTarget = null;
                if (outputObserver != null) {
                    outputObserver.checkAndNotify();
                    List<File> newOutputFiles = faListener.getNewOutputFiles();
                    this.outputProcessor.process(newOutputFiles, tgt, null);
                    try {
                        outputObserver.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.result.addProcessFlowInfo(this, 500, tgt.getClassName(), modelProviderId);
            }
        }
    }

    private FileAlterationObserver setupOutputFileAlterationObserver(String outputDirectory, OutputFileAlterationListener listener, TargetConfiguration tgt) {
        String outputDir = outputDirectory != null ? outputDirectory : ".";
        File outputDirectoryFile = new File(outputDir);
        if (!outputDirectoryFile.exists()) {
            try {
                FileUtils.forceMkdir((File)outputDirectoryFile);
            }
            catch (IOException e) {
                this.result.addProcessFlowError(this, 516, outputDir);
                return null;
            }
        }
        try {
            FileAlterationObserver observer = new FileAlterationObserver(outputDirectoryFile);
            observer.initialize();
            observer.addListener((FileAlterationListener)listener);
            return observer;
        }
        catch (Exception e) {
            this.result.addProcessFlowError(this, 517, outputDir);
            return null;
        }
    }

    private void executeTransformations(Model model, List<TransformerConfiguration> transformerConfigs) throws Exception {
        int numberOfDisabledTransformers = 0;
        String idOfLastEnabledTransformer = "UNKNOWN";
        for (TransformerConfiguration trf : transformerConfigs) {
            if (trf.getProcessMode() == ProcessMode.disabled) {
                ++numberOfDisabledTransformers;
                continue;
            }
            idOfLastEnabledTransformer = trf.getId();
        }
        boolean modelCopyRequired = transformerConfigs.size() - numberOfDisabledTransformers > 1 || !(model instanceof GenericModel);
        for (TransformerConfiguration trf : transformerConfigs) {
            GenericModel modelOutput;
            block13: {
                this.options.setCurrentProcessConfig(trf);
                modelOutput = null;
                if (trf.getProcessMode() == ProcessMode.disabled) {
                    this.processIdsToIgnore.add(trf.getId());
                    this.result.addProcessFlowInfo(this, 506, trf.getId());
                } else if (this.processIdsToIgnore.contains(trf.getInputId())) {
                    this.processIdsToIgnore.add(trf.getId());
                }
                if (!this.processIdsToIgnore.contains(trf.getId())) {
                    try {
                        GenericModel modelInput;
                        this.result.addProcessFlowInfo(this, 501, trf.getId(), trf.getInputId());
                        if (modelCopyRequired) {
                            this.result.addProcessFlowDebug("Creating GenericModel...");
                            modelInput = new GenericModel(model);
                            this.result.addProcessFlowDebug("...done.");
                        } else {
                            this.result.addProcessFlowDebug("Creation of GenericModel is not required.");
                            modelInput = (GenericModel)model;
                        }
                        this.options.resetFields();
                        TransformationManager trfManager = new TransformationManager();
                        StatusBoard.getStatusBoard().statusChanged(206);
                        modelOutput = trfManager.process(modelInput, this.options, trf, this.result);
                        if (modelCopyRequired && trf.getId().equals(idOfLastEnabledTransformer)) {
                            this.result.addProcessFlowDebug("Releasing model created by processing step: " + trf.getInputId());
                            this.release(model);
                        }
                        this.result.addProcessFlowInfo(this, 502, trf.getId(), trf.getInputId());
                    }
                    catch (ClassCastException e) {
                        this.processIdsToIgnore.add(trf.getId());
                        this.result.addProcessFlowError(this, 505, e.getMessage(), trf.getId());
                        StackTraceElement[] stes = e.getStackTrace();
                        if (stes == null) break block13;
                        for (StackTraceElement ste : stes) {
                            this.result.addProcessFlowDebug(ste.toString());
                        }
                    }
                }
            }
            this.executeTargets(modelOutput, trf.getId(), trf.getTargets());
            this.executeTransformations(modelOutput, trf.getTransformers());
        }
    }

    private void executeTargets(Model model, String modelProviderId, List<TargetConfiguration> targetConfigs) throws ShapeChangeAbortException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        if (this.processIdsToIgnore.contains(modelProviderId)) {
            return;
        }
        for (TargetConfiguration tgt : targetConfigs) {
            if (tgt.getProcessMode().equals((Object)ProcessMode.disabled)) continue;
            this.options.setCurrentProcessConfig(tgt);
            this.options.resetFields();
            this.resetSingleTargets();
            Object outputDirectory = this.options.parameter(tgt.getClassName(), "outputDirectory");
            if (outputDirectory != null && ((String)outputDirectory).length() > 0) {
                outputDirectory = ((String)outputDirectory).trim() + File.separator + modelProviderId;
                this.options.setParameter(tgt.getClassName(), "outputDirectory", (String)outputDirectory);
            }
            OutputFileAlterationListener faListener = new OutputFileAlterationListener();
            FileAlterationObserver outputObserver = this.setupOutputFileAlterationObserver((String)outputDirectory, faListener, tgt);
            SortedSet<? extends PackageInfo> selectedSchemas = model.selectedSchemas();
            this.mainSchemaForSingleTargets = TargetUtil.findMainSchemaForSingleTargets(selectedSchemas, this.options, this.result);
            String classname = tgt.getClassName();
            ProcessMode tmode = this.options.targetMode(classname);
            Class<?> theClass = Class.forName(classname);
            boolean targetCalled = false;
            for (PackageInfo packageInfo : selectedSchemas) {
                if (packageInfo == null || this.options.skipSchema(packageInfo)) continue;
                String name = packageInfo.name();
                String ns = packageInfo.targetNamespace();
                if (ns == null) {
                    ns = "(no namespace)";
                }
                this.result.addProcessFlowInfo(this, 1012, name, ns);
                if (tmode.equals((Object)ProcessMode.disabled)) continue;
                this.target = (Target)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (this.target != null) {
                    targetCalled = true;
                    this.result.addProcessFlowInfo(this, 503, this.target.getTargetName(), modelProviderId);
                    StatusBoard.getStatusBoard().statusChanged(201);
                    this.target.initialise(packageInfo, model, this.options, this.result, tmode.equals((Object)ProcessMode.diagnosticsonly));
                    StatusBoard.getStatusBoard().statusChanged(202);
                    ClassInfo[] classArr = this.classes(model, packageInfo);
                    for (int cidx = 0; cidx < classArr.length; ++cidx) {
                        ClassInfo k = classArr[cidx];
                        this.target.process(k);
                    }
                    StatusBoard.getStatusBoard().statusChanged(203);
                    this.target.write();
                    if (outputObserver != null) {
                        if (!this.isSingleTarget(theClass) && !this.isDeferrableOutputWriter(theClass)) {
                            outputObserver.checkAndNotify();
                            List<File> newOutputFiles = faListener.getNewOutputFiles();
                            this.outputProcessor.process(newOutputFiles, tgt, packageInfo);
                        }
                        try {
                            outputObserver.initialize();
                        }
                        catch (Exception e) {
                            this.result.addProcessFlowError(this, 517, (String)outputDirectory);
                        }
                    }
                }
                this.target = null;
            }
            if (!tmode.equals((Object)ProcessMode.disabled) && targetCalled && this.isSingleTarget(theClass)) {
                SingleTarget starget = (SingleTarget)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.target = starget;
                if (starget != null) {
                    StatusBoard.getStatusBoard().statusChanged(204);
                    starget.writeAll(this.result);
                    if (outputObserver != null && !this.isDeferrableOutputWriter(theClass)) {
                        outputObserver.checkAndNotify();
                        List<File> list = faListener.getNewOutputFiles();
                        this.outputProcessor.process(list, tgt, this.mainSchemaForSingleTargets);
                        try {
                            outputObserver.initialize();
                        }
                        catch (Exception e) {
                            this.result.addProcessFlowError(this, 517, (String)outputDirectory);
                        }
                    }
                }
                this.target = null;
            }
            if (outputObserver != null) {
                try {
                    outputObserver.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.result.addProcessFlowInfo(this, 504, tgt.getClassName(), modelProviderId);
        }
    }

    private ClassInfo[] classes(Model model, PackageInfo pi) throws NoSuchMethodException, SecurityException {
        SortedSet<ClassInfo> classes = model.classes(pi);
        String sortedOpt = this.options.parameter(this.target.getClass().getName(), "sortedOutput");
        if (sortedOpt == null) {
            sortedOpt = this.options.parameter("sortedOutput");
        }
        ClassInfo[] classArr = new ClassInfo[classes.size()];
        classes.toArray(classArr);
        if (sortedOpt != null && !"false".equalsIgnoreCase(sortedOpt)) {
            String compField;
            Class[] paramTypes = null;
            Object[] pargs = null;
            if ("true".equalsIgnoreCase(sortedOpt)) {
                compField = "name";
            } else if (sortedOpt.startsWith("taggedValue=")) {
                compField = "taggedValue";
                String parg = sortedOpt.split("=")[1];
                paramTypes = new Class[]{String.class};
                pargs = new Object[]{parg};
            } else {
                compField = sortedOpt;
            }
            try {
                ClassInfo.class.getMethod(compField, paramTypes);
            }
            catch (NoSuchMethodException e) {
                this.result.addProcessFlowError(this, 165, sortedOpt, this.target.getClass().getName());
                return classArr;
            }
            final Method compMeth = ClassInfo.class.getMethod(compField, paramTypes);
            final Object[] compMethArgs = pargs;
            Arrays.sort(classArr, new Comparator<ClassInfo>(){

                @Override
                public int compare(ClassInfo ci1, ClassInfo ci2) {
                    try {
                        if (compMeth.getName().equals("taggedValue")) {
                            String s1 = ci1.taggedValue((String)compMethArgs[0]);
                            String s2 = ci2.taggedValue((String)compMethArgs[0]);
                            if (StringUtils.isBlank((CharSequence)s1)) {
                                s1 = ci1.name();
                            }
                            if (StringUtils.isBlank((CharSequence)s2)) {
                                s2 = ci2.name();
                            }
                            return s1.compareTo(s2);
                        }
                        return ((String)compMeth.invoke((Object)ci1, new Object[0])).compareTo((String)compMeth.invoke((Object)ci2, new Object[0]));
                    }
                    catch (Exception e) {
                        String m = e.getMessage();
                        if (m != null) {
                            Converter.this.result.addProcessFlowError(m);
                        }
                        return 0;
                    }
                }
            });
        }
        return classArr;
    }

    private void resetSingleTargets() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Vector<String> targets = this.options.targets();
        for (String classname : targets) {
            SingleTarget starget;
            ProcessMode tmode;
            Class<?> theClass = Class.forName(classname);
            this.target = (Target)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (this.target == null || (tmode = this.options.targetMode(classname)).equals((Object)ProcessMode.disabled) || !this.isSingleTarget(theClass) || (starget = (SingleTarget)theClass.getConstructor(new Class[0]).newInstance(new Object[0])) == null) continue;
            starget.reset();
        }
    }

    private boolean isSingleTarget(Class theClass) {
        for (Class<?> intfc : theClass.getInterfaces()) {
            String in = intfc.getName();
            if (!in.equals("de.interactive_instruments.ShapeChange.Target.SingleTarget")) continue;
            return true;
        }
        return false;
    }

    private boolean isDeferrableOutputWriter(Class theClass) {
        for (Class<?> intfc : theClass.getInterfaces()) {
            String in = intfc.getName();
            if (!in.equals("de.interactive_instruments.ShapeChange.Target.DeferrableOutputWriter")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 14: {
                return "No model has been loaded to convert.";
            }
            case 165: {
                return "Value '$1$' is not allowed for targetParameter 'sortedOutput' in Target '$2$'. Try 'true' (=name), 'name', 'id', 'taggedValue=value' or 'false' (no sorting). 'false' is used.";
            }
            case 500: {
                return "Executed deferred output write for target class '$1$' for input ID: '$2$'.";
            }
            case 501: {
                return "Now processing transformation '$1$' for input ID: '$2$'.";
            }
            case 502: {
                return "Performed transformation for transformer ID '$1$' for input ID: '$2$'.\n-------------------------------------------------";
            }
            case 503: {
                return "Now processing target '$1$' for input '$2$'.";
            }
            case 504: {
                return "Executed target class '$1$' for input ID: '$2$'.\n-------------------------------------------------";
            }
            case 505: {
                return "Internal class cast exception encountered - message: $1$ (full exception information is only logged for log level debug). Processing of transformation with ID '$2$' did not succeed. All transformations and targets that depend on this transformation will not be executed.";
            }
            case 506: {
                return "Transformation with ID '$1$' is disabled (via the configuration). All transformations and targets that depend on this transformation will not be executed.";
            }
            case 507: {
                return "None of the packages contained in the model is a schema selected for processing. Make sure that the schema you want to process are configured to be a schema (via the 'targetNamespace' tagged value or via a PackageInfo element in the configuration) and also selected for processing (if you use one of the input parameters appSchemaName, appSchemaNameRegex, appSchemaNamespaceRegex, ensure that they include the schema). Execution will stop now.";
            }
            case 508: {
                return "??The ConfigurationValidator for transformer or target class '$1$' was found but could not be loaded. Exception message is: $2$";
            }
            case 509: {
                return "The semantic validation of the ShapeChange configuration detected one or more errors. Examine the log for further details. Execution will stop now.";
            }
            case 510: {
                return "---------- Semantic validation of ShapeChange configuration: START ----------";
            }
            case 511: {
                return "---------- Semantic validation of ShapeChange configuration: COMPLETE ----------";
            }
            case 512: {
                return "---------- Semantic validation of ShapeChange configuration: SKIPPED ----------";
            }
            case 513: {
                return "NOTE: The semantic validation can be skipped by setting the input configuration parameter 'skipSemanticValidationOfShapeChangeConfiguration' to 'true'.";
            }
            case 514: {
                return "--- Validating transformer with @id '$1$' ...";
            }
            case 515: {
                return "--- Validating target with @class '$1$' and @inputs '$2$' ...";
            }
            case 516: {
                return "Could not create output directory '$1$' and thus could not set up file observer to identify output files that are created in this directory by targets. Processing of output files in this directory will not be performed.";
            }
            case 517: {
                return "Could not initialize file observer for output directory '$1$'. The file observer would be used to identify output files that are created in this directory by targets. Processing of output files in this directory will not be performed.";
            }
            case 1012: {
                return "Application schema found, package name: '$1$', target namespace: '$2$'";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

