/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassSelector {
    private Pattern namePattern;
    private Pattern stereotypePattern;

    public ClassSelector(Pattern namePattern, Pattern stereotypePattern) {
        this.namePattern = namePattern;
        this.stereotypePattern = stereotypePattern;
    }

    public ClassSelector() {
    }

    public SortedSet<ClassInfo> selectClasses(Model m, Set<PackageInfo> owners) {
        TreeSet<ClassInfo> result = new TreeSet<ClassInfo>();
        SortedSet<? extends PackageInfo> selectedSchemas = m.selectedSchemas();
        if (selectedSchemas != null && !selectedSchemas.isEmpty()) {
            TreeSet<ClassInfo> selSchemaClasses = new TreeSet<ClassInfo>();
            for (PackageInfo packageInfo : selectedSchemas) {
                selSchemaClasses.addAll(m.classes(packageInfo));
            }
            for (ClassInfo classInfo : selSchemaClasses) {
                if (owners != null && !owners.contains(classInfo.pkg()) || !this.nameMatches(this.namePattern, classInfo) || !this.oneStereotypeMatches(this.stereotypePattern, classInfo)) continue;
                result.add(classInfo);
            }
        }
        return result;
    }

    private boolean oneStereotypeMatches(Pattern p, ClassInfo ci) {
        if (p != null) {
            String[] stsArr;
            Stereotypes sts = ci.stereotypes();
            for (String st : stsArr = sts.asArray()) {
                if (!this.matchesRegex(st, p)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean nameMatches(Pattern p, ClassInfo ci) {
        if (p != null) {
            return this.matchesRegex(ci.name(), p);
        }
        return true;
    }

    private boolean matchesRegex(String s, Pattern p) {
        Matcher matcher = p.matcher(s);
        return matcher.matches();
    }

    public void setNamePattern(Pattern namePattern) {
        this.namePattern = namePattern;
    }

    public void setStereotypePattern(Pattern stereotypePattern) {
        this.stereotypePattern = stereotypePattern;
    }
}

