/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import com.google.common.base.Joiner;
import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.ModelElementSelectionParseException;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.TaggedValueConfigurationEntry;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import de.interactive_instruments.ShapeChange.TargetXmlSchemaConfiguration;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.XsdMapEntry;
import de.interactive_instruments.ShapeChange.XsdPropertyMapEntry;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;

public class BasicConfigurationValidator
extends AbstractConfigurationValidator {
    @Override
    public boolean isValid(ProcessConfiguration pConfig, Options options, ShapeChangeResult result) {
        boolean isValid = true;
        result.addInfo(this, 3, "input");
        isValid = this.validateParameters(options.getInputAndLogParameterRegistry().getAllowedInputParametersWithStaticNames(), options.getInputAndLogParameterRegistry().getRegexesForAllowedInputParametersWithDynamicNames(), options.inputConfig.getParameters().keySet(), result) && isValid;
        result.addInfo(this, 4, "input");
        result.addInfo(this, 3, "log");
        isValid = this.validateParameters(options.getInputAndLogParameterRegistry().getAllowedLogParametersWithStaticNames(), options.getInputAndLogParameterRegistry().getRegexesForAllowedLogParametersWithDynamicNames(), options.logParameters.keySet(), result) && isValid;
        result.addInfo(this, 4, "log");
        String imt = options.parameter("inputModelType");
        if (imt == null) {
            result.addProcessFlowError(null, 26);
            isValid = false;
        }
        if (!imt.equalsIgnoreCase("EA7") || !options.isOnlyDeferrableOutputWrite()) {
            // empty if block
        }
        for (Map.Entry<String, TransformerConfiguration> entry : options.getTransformerConfigs().entrySet()) {
            String string = entry.getKey();
            TransformerConfiguration transformerConfiguration = entry.getValue();
            if (!transformerConfiguration.hasTaggedValues()) continue;
            for (TaggedValueConfigurationEntry tvce : transformerConfiguration.getTaggedValues()) {
                try {
                    tvce.getModelElementSelectionInfo().validate();
                }
                catch (ModelElementSelectionParseException e) {
                    isValid = false;
                    result.addError(this, 400, string, e.getMessage());
                }
            }
        }
        List<TargetConfiguration> targetConfigs = options.getTargetConfigurations();
        for (TargetConfiguration targetConfiguration : targetConfigs) {
            boolean bl = targetConfiguration.parameterAsBoolean("processOutput_applyXslt", false);
            if (!bl) continue;
            Joiner joiner = Joiner.on((String)", ");
            String pathToXsltDirectory = targetConfiguration.parameterAsString("processOutput_pathToXsltDirectory", ".", false, true);
            String xsltFileName = targetConfiguration.parameterAsString("processOutput_xsltFileName", null, false, true);
            if (xsltFileName == null) {
                result.addProcessFlowError(this, 102, targetConfiguration.getClassName(), joiner.join(targetConfiguration.getInputIds()));
                isValid = false;
                continue;
            }
            if (pathToXsltDirectory.toLowerCase().startsWith("http")) {
                String urlString = pathToXsltDirectory + "/" + xsltFileName;
                try {
                    URL url = new URL(urlString);
                    url.toURI();
                }
                catch (MalformedURLException | URISyntaxException e) {
                    result.addProcessFlowError(this, 100, targetConfiguration.getClassName(), joiner.join(targetConfiguration.getInputIds()), urlString, e.getMessage());
                    isValid = false;
                }
                continue;
            }
            File xsl = new File(pathToXsltDirectory + "/" + xsltFileName);
            if (xsl.exists()) continue;
            result.addProcessFlowError(this, 101, targetConfiguration.getClassName(), joiner.join(targetConfiguration.getInputIds()), xsl.getAbsolutePath());
            isValid = false;
        }
        SortedMap<String, String> sortedMap = options.getInputConfig().getDescriptorSources();
        for (Map.Entry<String, String> entry : sortedMap.entrySet()) {
            String[] components = StringUtils.splitPreserveAllTokens((String)entry.getValue(), (String)"#");
            if (components[0].equalsIgnoreCase("sc:extract") && components[1].length() == 0) {
                result.addProcessFlowError(this, 200, entry.getKey());
                isValid = false;
                continue;
            }
            if (!components[0].equalsIgnoreCase("tag") || components[1].length() != 0) continue;
            result.addProcessFlowError(this, 201, entry.getKey());
            isValid = false;
        }
        for (TargetConfiguration targetConfiguration : targetConfigs) {
            if (!(targetConfiguration instanceof TargetXmlSchemaConfiguration)) continue;
            TargetXmlSchemaConfiguration xsdConf = (TargetXmlSchemaConfiguration)targetConfiguration;
            List<XsdMapEntry> xsdMapEntries = xsdConf.getXsdMapEntries();
            for (XsdMapEntry xsdme : xsdMapEntries) {
                if (xsdme.getXmlElementHasSimpleContent() == null || xsdme.hasXmlElement()) continue;
                result.addProcessFlowError(this, 300, xsdme.getType(), String.join((CharSequence)" ", xsdme.getEncodingRules()));
                isValid = false;
            }
            for (XsdPropertyMapEntry xpme : xsdConf.getXsdPropertyMapEntries().values()) {
                if (!xpme.hasTargetElement()) continue;
                String targetElement = xpme.getTargetElement();
                if (StringUtils.countMatches((CharSequence)targetElement, (CharSequence)":") != 1) {
                    result.addProcessFlowError(this, 301, xpme.toString());
                    isValid = false;
                    continue;
                }
                String nsabr = targetElement.split(":")[0];
                if (options.fullNamespace(nsabr) != null) continue;
                result.addProcessFlowError(this, 302, xpme.toString(), nsabr);
                isValid = false;
            }
        }
        SortedSet<String> sortedSet = options.getRuleRegistry().getRuleRegistrationErrors();
        isValid = isValid && sortedSet.isEmpty();
        for (String err : sortedSet) {
            result.addProcessFlowError(this, 500, err);
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class BasicConfigurationValidator";
            }
            case 1: {
                return "The input parameter 'inputModelType' is set to 'EA7'. When loading an Enterprise Architect model, ShapeChange must be executed in Windows OS. ShapeChange detected that it is run in a different OS.";
            }
            case 2: {
                return "The input parameter 'inputModelType' is set to 'EA7'. When loading an Enterprise Architect model, ShapeChange must be executed in Windows OS with a 32bit JRE. ShapeChange detected that it is not executed with a 32bit JRE. The value of system property 'os.arch' is: '$1$'.";
            }
            case 3: {
                return "Validating $1$ parameters.";
            }
            case 4: {
                return "Validation of $1$ parameters completed.";
            }
            case 100: {
                return "XSL transformation of output files is requested via configuration parameter 'processOutput_applyXslt' for target with class name '$1$' and input(s) '$2$'. The URL that results from concatenating the path to the XSL directory and the XSLT file name - '$3$' - could not be converted to a URI. Exception message is: '$4$'.";
            }
            case 101: {
                return "XSL transformation of output files is requested via configuration parameter 'processOutput_applyXslt' for target with class name '$1$' and input(s) '$2$'. No XSL file was found at location '$3$'.";
            }
            case 102: {
                return "XSL transformation of output files is requested via configuration parameter 'processOutput_applyXslt' for target with class name '$1$' and input(s) '$2$'. Required parameter 'processOutput_applyXslt' was not configured (or does not contain a non-empty value).";
            }
            case 200: {
                return "Source for descriptor '$1$' is 'sc:extract', but required token is not provided.";
            }
            case 201: {
                return "Source for descriptor '$1$' is 'tag', but required tag is not provided.";
            }
            case 300: {
                return "XsdMapEntry with @type '$1$' and @xsdEncodingRule '$2$' is invalid because @xmlElementHasSimpleContent is set but @xmlElement has no value.";
            }
            case 301: {
                return "XsdPropertyMapEntry '$1$' is invalid because the @targetElement is not a QName like string.";
            }
            case 302: {
                return "XsdPropertyMapEntry '$1$' is invalid because the configuration does not contain a namespace definition with the namespace prefix '$2$', which is used by the @targetElement.";
            }
            case 400: {
                return "Transformer with id '$1$' has invalid model element selection criteria in TaggedValue element. Details: $2$";
            }
            case 500: {
                return "Invalid rule setup: $1$";
            }
        }
        return "(" + BasicConfigurationValidator.class.getName() + ") Unknown message with number: " + mnr;
    }
}

