/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ConfigurationValidator;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.Target.TargetOutputProcessor;
import de.interactive_instruments.ShapeChange.Transformation.TransformationManager;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.text.similarity.LevenshteinDistance;

public abstract class AbstractConfigurationValidator
implements ConfigurationValidator,
MessageSource {
    protected LevenshteinDistance levDistance = new LevenshteinDistance(Integer.valueOf(3));

    public boolean validateParameters(SortedSet<String> allowedParametersWithStaticNames, List<Pattern> regexesForAllowedParametersWithDynamicNames, Set<String> actualParameters, ShapeChangeResult result) {
        boolean reportUnrecognizedParametersAsWarnings = result.options().reportUnrecognizedParametersAsWarnings();
        boolean allParametersValid = true;
        if (actualParameters != null) {
            for (String parameter : actualParameters) {
                boolean isAllowed = false;
                if (allowedParametersWithStaticNames != null) {
                    isAllowed = allowedParametersWithStaticNames.contains(parameter);
                }
                if (!isAllowed && regexesForAllowedParametersWithDynamicNames != null) {
                    for (Pattern regex : regexesForAllowedParametersWithDynamicNames) {
                        if (!regex.matcher(parameter).matches()) continue;
                        isAllowed = true;
                        break;
                    }
                }
                if (isAllowed) continue;
                allParametersValid = false;
                String allowedParameterWithNearStringDistance = null;
                if (allowedParametersWithStaticNames != null) {
                    for (String allowedParameter : allowedParametersWithStaticNames) {
                        if (this.levDistance.apply((CharSequence)parameter, (CharSequence)allowedParameter) == -1) continue;
                        allowedParameterWithNearStringDistance = allowedParameter;
                        break;
                    }
                }
                if (allowedParameterWithNearStringDistance != null) {
                    if (reportUnrecognizedParametersAsWarnings) {
                        result.addWarning(null, 1000000, parameter, allowedParameterWithNearStringDistance);
                        continue;
                    }
                    result.addError(null, 1000000, parameter, allowedParameterWithNearStringDistance);
                    continue;
                }
                if (reportUnrecognizedParametersAsWarnings) {
                    result.addWarning(null, 1000001, parameter);
                    continue;
                }
                result.addError(null, 1000001, parameter);
            }
        }
        return reportUnrecognizedParametersAsWarnings || allParametersValid;
    }

    public SortedSet<String> getCommonTransformerParameters() {
        return TransformationManager.getRecognizedParameters();
    }

    public SortedSet<String> getCommonTargetParameters() {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(Target.COMMON_TARGET_PARAMETERS);
        result.addAll(TargetOutputProcessor.getRecognizedParameters());
        return result;
    }
}

