/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.proj;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.sf.proj.AuthorityProjections;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionRetriever;
import mil.nga.sf.proj.Projections;
import mil.nga.sf.util.SFException;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;

public class ProjectionFactory {
    private static final Logger logger = Logger.getLogger(ProjectionFactory.class.getName());
    private static final CRSFactory csFactory = new CRSFactory();
    private static Projections projections = new Projections();

    public static Projection getProjection(long epsg) {
        return ProjectionFactory.getProjection("EPSG", String.valueOf(epsg));
    }

    public static Projection getProjection(String authority, long code) {
        return ProjectionFactory.getProjection(authority, String.valueOf(code));
    }

    public static Projection getProjection(String authority, String code) {
        return ProjectionFactory.getProjection(authority, code, null, null);
    }

    public static Projection getProjection(String authority, long code, String paramStr) {
        return ProjectionFactory.getProjection(authority, String.valueOf(code), paramStr);
    }

    public static Projection getProjection(String authority, String code, String paramStr) {
        String[] params = null;
        if (paramStr != null && !paramStr.isEmpty()) {
            params = paramStr.split("\\s+");
        }
        Projection projection = ProjectionFactory.getProjection(authority, code, params);
        return projection;
    }

    public static Projection getProjection(String authority, long code, String[] params) {
        return ProjectionFactory.getProjection(authority, String.valueOf(code), params);
    }

    public static Projection getProjection(String authority, String code, String[] params) {
        return ProjectionFactory.getProjection(authority, code, params, null);
    }

    public static Projection getProjection(String authority, long code, String[] params, String definition) {
        return ProjectionFactory.getProjection(authority, String.valueOf(code), params, definition);
    }

    public static Projection getProjection(String authority, String code, String[] params, String definition) {
        Projection projection = projections.getProjection(authority = authority.toUpperCase(), code);
        if (projection == null && (projection = ProjectionFactory.fromDefinition(authority, code, definition)) == null && (projection = ProjectionFactory.fromParams(authority, code, params)) == null && (projection = ProjectionFactory.fromProperties(authority, code)) == null && (projection = ProjectionFactory.fromName(authority, code)) == null) {
            throw new SFException("Failed to create projection for authority: " + authority + ", code: " + code + ", definition: " + definition + ", params: " + Arrays.toString(params));
        }
        return projection;
    }

    public static Projections getProjections() {
        return projections;
    }

    public static AuthorityProjections getProjections(String authority) {
        return projections.getProjections(authority);
    }

    public static void clear() {
        projections.clear();
    }

    public static void clear(String authority) {
        projections.clear(authority);
    }

    public static void clear(String authority, long code) {
        projections.remove(authority, code);
    }

    public static void clear(String authority, String code) {
        projections.remove(authority, code);
    }

    private static Projection fromDefinition(String authority, String code, String definition) {
        String parametersString;
        Projection projection = null;
        if (definition != null && !definition.isEmpty() && (parametersString = "") != null && !parametersString.isEmpty()) {
            try {
                CoordinateReferenceSystem crs = csFactory.createFromParameters(ProjectionFactory.coordinateName(authority, code), parametersString);
                projection = new Projection(authority, code, crs);
                projections.addProjection(projection);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create projection for authority: " + authority + ", code: " + code + ", definition: " + definition + ", parameters: " + parametersString, e);
            }
        }
        return projection;
    }

    private static Projection fromParams(String authority, String code, String[] params) {
        Projection projection = null;
        if (params != null && params.length > 0) {
            try {
                CoordinateReferenceSystem crs = csFactory.createFromParameters(ProjectionFactory.coordinateName(authority, code), params);
                projection = new Projection(authority, code, crs);
                projections.addProjection(projection);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create projection for authority: " + authority + ", code: " + code + ", parameters: " + Arrays.toString(params), e);
            }
        }
        return projection;
    }

    private static Projection fromProperties(String authority, String code) {
        Projection projection = null;
        String parameters = ProjectionRetriever.getProjection(authority, code);
        if (parameters != null && !parameters.isEmpty()) {
            try {
                CoordinateReferenceSystem crs = csFactory.createFromParameters(ProjectionFactory.coordinateName(authority, code), parameters);
                projection = new Projection(authority, code, crs);
                projections.addProjection(projection);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create projection for authority: " + authority + ", code: " + code + ", parameters: " + parameters, e);
            }
        }
        return projection;
    }

    private static Projection fromName(String authority, String code) {
        Projection projection = null;
        String name = ProjectionFactory.coordinateName(authority, code);
        try {
            CoordinateReferenceSystem crs = csFactory.createFromName(name);
            projection = new Projection(authority, code, crs);
            projections.addProjection(projection);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create projection from name: " + name, e);
        }
        return projection;
    }

    private static String coordinateName(String authority, String code) {
        return authority.toUpperCase() + ":" + code;
    }
}

