/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.wkb;

import java.io.IOException;
import java.nio.ByteOrder;
import mil.nga.sf.CircularString;
import mil.nga.sf.CompoundCurve;
import mil.nga.sf.Curve;
import mil.nga.sf.CurvePolygon;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.MultiLineString;
import mil.nga.sf.MultiPoint;
import mil.nga.sf.MultiPolygon;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.PolyhedralSurface;
import mil.nga.sf.TIN;
import mil.nga.sf.Triangle;
import mil.nga.sf.util.ByteWriter;
import mil.nga.sf.util.SFException;
import mil.nga.sf.wkb.GeometryCodes;

public class GeometryWriter {
    public static void writeGeometry(ByteWriter writer, Geometry geometry) throws IOException {
        byte byteOrder = writer.getByteOrder() == ByteOrder.BIG_ENDIAN ? (byte)0 : 1;
        writer.writeByte(byteOrder);
        writer.writeInt(GeometryCodes.getCode(geometry));
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case GEOMETRY: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POINT: {
                GeometryWriter.writePoint(writer, (Point)geometry);
                break;
            }
            case LINESTRING: {
                GeometryWriter.writeLineString(writer, (LineString)geometry);
                break;
            }
            case POLYGON: {
                GeometryWriter.writePolygon(writer, (Polygon)geometry);
                break;
            }
            case MULTIPOINT: {
                GeometryWriter.writeMultiPoint(writer, (MultiPoint)geometry);
                break;
            }
            case MULTILINESTRING: {
                GeometryWriter.writeMultiLineString(writer, (MultiLineString)geometry);
                break;
            }
            case MULTIPOLYGON: {
                GeometryWriter.writeMultiPolygon(writer, (MultiPolygon)geometry);
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                GeometryWriter.writeGeometryCollection(writer, (GeometryCollection)geometry);
                break;
            }
            case CIRCULARSTRING: {
                GeometryWriter.writeCircularString(writer, (CircularString)geometry);
                break;
            }
            case COMPOUNDCURVE: {
                GeometryWriter.writeCompoundCurve(writer, (CompoundCurve)geometry);
                break;
            }
            case CURVEPOLYGON: {
                GeometryWriter.writeCurvePolygon(writer, (CurvePolygon)geometry);
                break;
            }
            case CURVE: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case SURFACE: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POLYHEDRALSURFACE: {
                GeometryWriter.writePolyhedralSurface(writer, (PolyhedralSurface)geometry);
                break;
            }
            case TIN: {
                GeometryWriter.writeTIN(writer, (TIN)geometry);
                break;
            }
            case TRIANGLE: {
                GeometryWriter.writeTriangle(writer, (Triangle)geometry);
                break;
            }
            default: {
                throw new SFException("Geometry Type not supported: " + geometryType);
            }
        }
    }

    public static void writePoint(ByteWriter writer, Point point) throws IOException {
        writer.writeDouble(point.getX());
        writer.writeDouble(point.getY());
        if (point.hasZ()) {
            writer.writeDouble(point.getZ().doubleValue());
        }
        if (point.hasM()) {
            writer.writeDouble(point.getM().doubleValue());
        }
    }

    public static void writeLineString(ByteWriter writer, LineString lineString) throws IOException {
        writer.writeInt(lineString.numPoints());
        for (Point point : lineString.getPoints()) {
            GeometryWriter.writePoint(writer, point);
        }
    }

    public static void writePolygon(ByteWriter writer, Polygon polygon) throws IOException {
        writer.writeInt(polygon.numRings());
        for (LineString ring : polygon.getRings()) {
            GeometryWriter.writeLineString(writer, ring);
        }
    }

    public static void writeMultiPoint(ByteWriter writer, MultiPoint multiPoint) throws IOException {
        writer.writeInt(multiPoint.numPoints());
        for (Point point : multiPoint.getPoints()) {
            GeometryWriter.writeGeometry(writer, (Geometry)point);
        }
    }

    public static void writeMultiLineString(ByteWriter writer, MultiLineString multiLineString) throws IOException {
        writer.writeInt(multiLineString.numLineStrings());
        for (LineString lineString : multiLineString.getLineStrings()) {
            GeometryWriter.writeGeometry(writer, (Geometry)lineString);
        }
    }

    public static void writeMultiPolygon(ByteWriter writer, MultiPolygon multiPolygon) throws IOException {
        writer.writeInt(multiPolygon.numPolygons());
        for (Polygon polygon : multiPolygon.getPolygons()) {
            GeometryWriter.writeGeometry(writer, (Geometry)polygon);
        }
    }

    public static void writeGeometryCollection(ByteWriter writer, GeometryCollection<?> geometryCollection) throws IOException {
        writer.writeInt(geometryCollection.numGeometries());
        for (Geometry geometry : geometryCollection.getGeometries()) {
            GeometryWriter.writeGeometry(writer, geometry);
        }
    }

    public static void writeCircularString(ByteWriter writer, CircularString circularString) throws IOException {
        writer.writeInt(circularString.numPoints());
        for (Point point : circularString.getPoints()) {
            GeometryWriter.writePoint(writer, point);
        }
    }

    public static void writeCompoundCurve(ByteWriter writer, CompoundCurve compoundCurve) throws IOException {
        writer.writeInt(compoundCurve.numLineStrings());
        for (LineString lineString : compoundCurve.getLineStrings()) {
            GeometryWriter.writeGeometry(writer, (Geometry)lineString);
        }
    }

    public static void writeCurvePolygon(ByteWriter writer, CurvePolygon<?> curvePolygon) throws IOException {
        writer.writeInt(curvePolygon.numRings());
        for (Curve ring : curvePolygon.getRings()) {
            GeometryWriter.writeGeometry(writer, (Geometry)ring);
        }
    }

    public static void writePolyhedralSurface(ByteWriter writer, PolyhedralSurface polyhedralSurface) throws IOException {
        writer.writeInt(polyhedralSurface.numPolygons());
        for (Polygon polygon : polyhedralSurface.getPolygons()) {
            GeometryWriter.writeGeometry(writer, (Geometry)polygon);
        }
    }

    public static void writeTIN(ByteWriter writer, TIN tin) throws IOException {
        writer.writeInt(tin.numPolygons());
        for (Polygon polygon : tin.getPolygons()) {
            GeometryWriter.writeGeometry(writer, (Geometry)polygon);
        }
    }

    public static void writeTriangle(ByteWriter writer, Triangle triangle) throws IOException {
        writer.writeInt(triangle.numRings());
        for (LineString ring : triangle.getRings()) {
            GeometryWriter.writeLineString(writer, ring);
        }
    }
}

